﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Img
{
    public partial class Form4 : Form
    {
        int w, h;
        float r;

        string fname;
        int Imgx, Imgy;
        float R, R1;
        public int X0, Y0, MFLG;

        private void button1_Click(object sender, EventArgs e)
        {
            string filePath = Path.GetFileName(fname);
            string fname1;
            fname1 = Path.GetFileNameWithoutExtension(fname);
            fname1 = fname1 + "-tmp"+ Path.GetExtension(fname);

            SaveFileDialog dlg = new SaveFileDialog()
            {

                FileName = Path.GetFileName(fname1), 
                Filter = "JPEG(*.jpg;*.jpeg)|*.jpg;*.jpeg|PNG(*.png)|*.png|Bitmap(*.bmp)|*.bmp",
                AddExtension = true,
                DefaultExt = ".jpg",
                RestoreDirectory = true,
                OverwritePrompt = true
            };


            if (dlg.ShowDialog() == DialogResult.OK)
            {
                // txtImagePath.Text = dlg.FileName;
                Image img = pictureBox1.Image;
                //               img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);

                dlg.Dispose();

                System.IO.FileInfo fileInfo = new System.IO.FileInfo(dlg.FileName);

                if (".png".Equals(fileInfo.Extension.ToLower()))
                {
                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Png);
                }
                else if (".jpg".Equals(fileInfo.Extension.ToLower()) || ".jpeg".Equals(fileInfo.Extension.ToLower()))
                {
                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Jpeg);
                }
                else if (".bmp".Equals(fileInfo.Extension.ToLower()))
                {
                    img.Save(dlg.FileName, System.Drawing.Imaging.ImageFormat.Bmp);
                }

            }

        }


        public Form4()
        {
            InitializeComponent();
        }

        private void Form4_Load(object sender, EventArgs e)
        {
            IDataObject data = Clipboard.GetDataObject();

            if (data.GetDataPresent(DataFormats.Text))
            {
                fname = (string)data.GetData(DataFormats.Text);
                label1.Text = System.IO.Path.GetFileName(fname);

            }
            if (data.GetDataPresent(DataFormats.Bitmap))
            {
                pictureBox1.Image = (Image)data.GetData(DataFormats.Bitmap);
            }
            int hh;
            Imgx = pictureBox1.Image.Width;
            Imgy = pictureBox1.Image.Height;

            R = Imgx / (float)Imgy;
            if (Imgx < Imgy)
            {
                Height = 900;
                Width = (int)((float)Width * R);
                R1 = (float)Imgx / (float)Width;
            }
            else
            {
                Width = 1000;
                Height = (int)((float)Width / R);
                R1 = (float)Imgx / (float)1000.0;
            }
            label2.Text = Imgx.ToString();
            label3.Text = Imgy.ToString();
        }
    }
}
